package fr.asip.cps3.exemple.vues.ecrans.saisie;

import java.awt.Color;
import java.awt.GridBagLayout;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.EmptyBorder;

import fr.asip.cps3.exemple.modele.objets.Algo;
import fr.asip.cps3.exemple.modele.objets.Cle;
import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;

/**
 * Classe permettant de modliser l'cran de saisie d'un Fichier et d'une Signature
 */
public class SaisieFichierSignature extends SaisieFichier {

	/**
	 * Cl de signature 
	 */
	protected Cle cle;
	
	/**
	 * Libell Signature 
	 */
	protected JLabel libelleSignature;
	
	/**
	 * Texte Signature
	 */
	protected JTextArea texteSignature;
	
	/**
	 * Ascenseur de la Signature
	 */
	private JScrollPane scrollSignature;
	
	/**
	 * Constructeur cran de signature
	 * @param fenetre La fentre qui doit contenir l'cran de saisie
	 * @param algo Algorithme de signature
	 * @param cle Cl utilis pour la signature
	 */
	public SaisieFichierSignature(FenetrePrincipale fenetre, int typeEcran, Algo algo, Cle cle) {

		super(fenetre,typeEcran,algo);
		this.cle = cle;

	}

	/**
	 * Constructeur cran de vrification de signature
	 * @param fenetre La fentre qui doit contenir l'cran de saisie
	 * @param algo Algorithme de signature
	 * @param cle Cl utilis pour la signature
	 * @param fichierSigne Fichier prcdement sign
	 * @param signature Signature du message
	 */
	public SaisieFichierSignature(FenetrePrincipale fenetre, int typeEcran, Algo algo, Cle cle, String fichierSigne, String signature) {

		this(fenetre,typeEcran,algo,cle);

		libelleSignature = new JLabel("Signature :");
		texteSignature = new JTextArea(signature);
		texteSignature.setLineWrap(true);
		texteSignature.setWrapStyleWord(true);	
		scrollSignature = new JScrollPane(texteSignature,ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED,ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		scrollSignature.setBackground(Color.white);
		
		texteFichier.setText(fichierSigne);

	}	
	
	/**
     * Renvoie la signature
     * @return Signature
     */
	public String getSignature() {
		if(texteSignature != null)
			return texteSignature.getText();
		return null;
	}

	/**
	 * Affiche les champs d'entre
	 * @param fenetre La fentre qui doit contenir l'cran d'entre
	 */
    public void affiche() {

    	JFrame fenetre = this.fenetre.getFenetre();
    	
    	if(fenetre != null && fenetre.getContentPane() != null) {
    	
	    	EcranUtil.supprimeTousLesComposants(((JPanel)fenetre.getContentPane()));
	    	
	        // Cration du layout
	    	((JPanel)fenetre.getContentPane()).setBorder(new EmptyBorder(0, 0, 0, 0));
	        GridBagLayout layout = new GridBagLayout();
	        ((JPanel)fenetre.getContentPane()).setLayout(layout);
	        
	        // Ajout des composants
	        GridBagHelper g = new GridBagHelper(fenetre.getContentPane());
	        // Ligne 0
	        g.ajoute(libelleFichier, EcranUtil.styleLibelleSaisieFichier, 0, 0, 1, 1);
	        g.ajoute(texteFichier, EcranUtil.styleChampTexteFichier, 0, 1, 1, 1);
	        g.ajoute(boutonParcourir, EcranUtil.styleBoutonParcourir, 0, 2, 1, 1);
	        
	        if(libelleSignature != null) {
		        // Ligne 1
		        g.ajoute(libelleSignature, EcranUtil.styleLibelleSaisieSignatureFichier, 1, 0, 1, 1);
		        g.ajoute(scrollSignature, EcranUtil.styleScrollSaisieSignature, 1, 1, 1, 2);
		        // Ligne 2
		        g.ajoute(soumettre, EcranUtil.styleBoutonSoumettre, 2, 0, 1, 3);
		        // Ligne 3
		        g.ajoute(barreStatut, EcranUtil.styleBarreStatut, 3, 0, 1, 3);

	        } else {
		        // Ligne 1
		        g.ajoute(soumettre, EcranUtil.styleBoutonSoumettre, 1, 0, 1, 3);
		        // Ligne 2
		        g.ajoute(barreStatut, EcranUtil.styleBarreStatut, 2, 0, 1, 3);	        	
	        }
	        
    	}
    }

	/**
	 * Accesseur
	 * @return Cl de signature associe  l'cran
	 */
	public Cle getCle() {
		return cle;
	}


    
}
